<?php

/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */

class DAuth{

	public static $db;

	public function __construct()
	{
		self::$db = DuoLam::app('DDbCommand');
	}

	//获取用户能访问的控制器   用户ID
	public function getController($userid)
	{
		$userid = (int)$userid;

		$result = self::$db->sqlCommand("SELECT `controller` FROM {{access}} WHERE `uid`=$userid",true);
		
		return $this->_setControllerName($result);

	}

	//获取用户能访问某个控制器的所有动作   用户ID 控制器名
	public function getAction($userid,$controller='')
	{
		$C = empty($controller) ? ucfirst(C) : ucfirst($controller);
		
		$userid = (int)$userid;

		$result = self::$db->sqlCommand()
						   -> select('`action`')
						   -> from('{{access}}')
						   -> where(array(
									'uid' => $userid,
									'controller' => $C
							  ))
						   -> fetch();
		return $this->_setActionStyle($result);

	}

	// 检查用户是否有访问指定控制器的权限，用户ID 控制器名
	public function accessController($userid,$controller='')
	{
		$C = empty($controller) ? ucfirst(C) : ucfirst($controller);

		$userid = (int)$userid;

		$count = self::$db->count("SELECT `uid` FROM {{access}} WHERE `uid`=$userid AND `controller`='$C'");

		return $count ? true : false;
	}

	//检查用户是否有访问指定动作的权限
	public function accessAction($userid,$controller='',$action='')
	{
		$C = empty($controller) ? ucfirst(C) : ucfirst($controller);

		$A = empty($action) ? A : $action;

		$userid = (int)$userid;

		$result = self::$db -> sqlCommand("SELECT `action` FROM {{access}} WHERE `uid`=$userid AND `controller`='$C'") -> fetch();

		//如果为 * 则是该控制器所有动作都能访问
		if($result['action'] == '*') return true;

		$result = $this->_setActionStyle($result);

		return in_array($A,$result) ? true : false;

	}

	//获取某用户的所有权限
	public function getUserAc($userid)
	{
		$userid = (int)$userid;

		$result = self::$db->sqlCommand("SELECT `controller`,`action` FROM {{access}} WHERE `uid`=$userid",true);

		foreach($result as $k =>$v)
		{
			$result[$k]['action'] = $this->_setActionStyle($v);
		}

		return $result;
	}
	
	//获取用户的用户组
	public function getGroup($userid)
	{
		$userid = (int)$userid;

		return self::$db->fetch("SELECT `name` FROM {{group}} WHERE `uid`=$userid");
	}

	//获取所有用户组
	public function getAllGroup()
	{
		return self::$db->sqlCommand('{{group}}',true);
	}

	//检查是否是超级管理员，注意，group表要有name=超级管理员，此方法才有效
	public function isManage($userid)
	{
		$result = $this->getGroup($userid);

		return $result['name']=='超级管理员' ? true : false;
	}

	//增加用户访问控制器权限
	public function addCmanage($userid,$controller='',$action=null)
	{
		$userid = (int)$userid;

		$C = empty($controller) ? ucfirst(C) : ucfirst($controller);
		
		$result = $this->accessController($userid,$C);
		
		if($result)
		{
			return false;
		}
		else
		{
			$param = array(
				'uid' => $userid,
				'controller' => $C,
				'action' => $action
			);
			self::$db->insert('{{access}}',$param);
			
			return true;
		}
	}

	//更新用户控制器的动作访问权限
	public function upAmanage($userid,$controller='',$action='*')
	{
		$userid = (int)$userid;

		$C = empty($controller) ? ucfirst(C) : ucfirst($controller);

		$param = array(
			'where' => "`uid`=$userid AND `controller` = '$C'",
			'data' => array('action'=>$action)
		);
		
		return self::$db->update('{{access}}',$param['data'],$param['where']);
	}

	//删除用户访问某控制器权限，控制器不填写，则删除该用户所有访问权限
	public function delCmanage($userid,$controller)
	{
		$userid = (int)$userid;

		$where = "uid=$userid";
		
		if(!empty($controller))
		{
			$where .= " AND `controller`='$controller'";
		}

		return self::$db->delete('{{access}}',$where);
	}

	//删除用户某控制器的动作权限，不指定，则删除该控制器所有权限
	public function delAmanage($userid,$controller='',$action)
	{
		$userid = (int)$userid;

		$C = empty($controller) ? ucfirst(C) : ucfirst($controller);

		if(empty($action))
		{
			self::$db->delete('{{access}}',"uid=$userid AND controller='$C'");
		}
		else
		{
			$result = $this->getAction($userid,$C);
			if(empty($result))  return false;
			foreach($result as $k =>$v)
			{
				if($v == $action)
				{
					unset($result[$k]);
					break;
				}
			}
			$data = implode(',',$result);
			return $this->upAmanage($userid,$C,$data);
		}
	}

	//增加用户组
	public function addGroup($userid,$name)
	{	
		$userid = (int)$userid;
		
		$data = array('uid'=>$userid,'name'=>$name);

		$result = $this->getGroup($userid);

		if($result) return false;

		self::$db->insert('{{group}}',$data);

		return true;
		
	}

	//删除用户组
	public function editGroup($userid,$name)
	{
		$userid = (int)$userid;

		$data = array('name'=>$name);

		return self::$db->update('{{group}}',$data,"uid=$userid");
	}

	public function delGroup($userid)
	{
		$userid = (int)$userid;

		return self::$db->delete('{{group}}',"uid=$userid");
	}

	private function _setActionStyle($result)
	{

		$data = explode(',',$result['action']);
		return empty($data) ? null : $data;
	}

	private function _setControllerName($result)
	{
		$data = array();
		if(is_array($result))
		{
			foreach($result as $v)
			{
				if(is_array($v))
				{
					$data[] = 'Action' . $v['controller'];
				}
				else
				{
					$data[] = 'Action' . $v;
				}
			}
		}

		return $data;
	}

	//安装权限控制数据表
	public static function installAuth()
	{
		//载入表结构
		$tables = include(DL_Root . 'Data' . DS . 'AuthMysql.php');

		//实例Command数据操作类
		$db = DuoLam::app('DDbCommand');
		
		//删除group、access表
		$db -> execute($tables['group']['drop']);
		$db -> execute($tables['access']['drop']);

		//建立group、access表结构
		$db -> execute($tables['group']['create']);
		$db -> execute($tables['access']['create']);

		//释放资源
		$db = null;

		return true;
	}

}